/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryCitizen
implements IItemHandlerModifiable,
INameable {
    private static final int NO_SLOT = -1;
    private static final int DEFAULT_INV_SIZE = 27;
    private static final int ROW_SIZE = 9;
    private int freeSlots = 27;
    private NonNullList<ItemStack> mainInventory = NonNullList.func_191197_a((int)27, (Object)ItemStackUtils.EMPTY);
    private int mainItem = -1;
    private int offhandItem = -1;
    private String customName;
    private ICitizenData citizen;

    public InventoryCitizen(String title, boolean localeEnabled, ICitizenData citizen) {
        this.citizen = citizen;
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public InventoryCitizen(String title, boolean localeEnabled) {
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ItemStack getHeldItem(Hand hand) {
        if (hand.equals((Object)Hand.MAIN_HAND)) {
            return this.getStackInSlot(this.mainItem);
        }
        return this.getStackInSlot(this.offhandItem);
    }

    public void setHeldItem(Hand hand, int slot) {
        if (hand.equals((Object)Hand.MAIN_HAND)) {
            this.mainItem = slot;
        }
        this.offhandItem = slot;
    }

    public int getHeldItemSlot(Hand hand) {
        if (hand.equals((Object)Hand.MAIN_HAND)) {
            return this.mainItem;
        }
        return this.offhandItem;
    }

    public int getSlots() {
        return this.mainInventory.size();
    }

    public boolean hasSpace() {
        return this.freeSlots > 0;
    }

    public boolean isEmpty() {
        return this.freeSlots == this.mainInventory.size();
    }

    public boolean isFull() {
        return this.freeSlots == 0;
    }

    private void resizeInventory(int size, int futureSize) {
        if (size < futureSize) {
            NonNullList inv = NonNullList.func_191197_a((int)futureSize, (Object)ItemStackUtils.EMPTY);
            for (int i = 0; i < this.mainInventory.size(); ++i) {
                inv.set(i, (Object)((ItemStack)this.mainInventory.get(i)));
            }
            this.mainInventory = inv;
            this.freeSlots += futureSize - size;
        }
    }

    @NotNull
    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.func_145818_k_() ? this.customName : "citizen.inventory");
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @NotNull
    public ItemStack getStackInSlot(int index) {
        if (index == -1) {
            return ItemStack.field_190927_a;
        }
        if (index >= this.mainInventory.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.mainInventory.get(index);
    }

    public <T extends LivingEntity> boolean damageInventoryItem(int slot, int amount, @Nullable T entityIn, @Nullable Consumer<T> onBroken) {
        ItemStack stack = (ItemStack)this.mainInventory.get(slot);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            stack.func_222118_a(stack.func_77973_b().damageItem(stack, amount, entityIn, onBroken), entityIn, onBroken);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
            }
        }
        return ItemStackUtils.isEmpty(stack);
    }

    public boolean shrinkInventoryItem(int slot) {
        ItemStack stack = (ItemStack)this.mainInventory.get(slot);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            stack.func_190920_e(stack.func_190916_E() - 1);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
            }
        }
        return ItemStackUtils.isEmpty(stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack copy = stack.func_77946_l();
        ItemStack inSlot = (ItemStack)this.mainInventory.get(slot);
        if (inSlot.func_190916_E() >= inSlot.func_77976_d() || !inSlot.func_190926_b() && !ItemStackUtils.compareItemStacksIgnoreStackSize(inSlot, copy).booleanValue()) {
            return copy;
        }
        if (inSlot.func_190926_b()) {
            if (!simulate) {
                this.markDirty();
                --this.freeSlots;
                this.mainInventory.set(slot, (Object)copy);
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        int avail = inSlot.func_77976_d() - inSlot.func_190916_E();
        if (avail >= copy.func_190916_E()) {
            if (!simulate) {
                this.markDirty();
                inSlot.func_190920_e(inSlot.func_190916_E() + copy.func_190916_E());
            }
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.markDirty();
            inSlot.func_190920_e(inSlot.func_190916_E() + avail);
        }
        copy.func_190920_e(copy.func_190916_E() - avail);
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack inSlot = (ItemStack)this.mainInventory.get(slot);
        if (inSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount >= inSlot.func_190916_E()) {
            if (!simulate) {
                this.markDirty();
                ++this.freeSlots;
                this.mainInventory.set(slot, (Object)ItemStack.field_190927_a);
            }
            return inSlot;
        }
        ItemStack copy = inSlot.func_77946_l();
        copy.func_190920_e(amount);
        if (!simulate) {
            this.markDirty();
            inSlot.func_190920_e(inSlot.func_190916_E() - amount);
            if (ItemStackUtils.isEmpty(inSlot).booleanValue()) {
                ++this.freeSlots;
            }
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void markDirty() {
        if (this.citizen != null) {
            this.citizen.markDirty();
        }
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new StringTextComponent(this.customName) : new StringTextComponent(this.citizen.getName());
    }

    public ListNBT write(ListNBT nbtTagList) {
        double researchEffect;
        if (this.citizen != null && this.citizen.getColony() != null && (researchEffect = this.citizen.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_INV_SLOTS)) > 0.0 && (double)this.mainInventory.size() < 27.0 + researchEffect) {
            this.resizeInventory(this.mainInventory.size(), (int)(27.0 + researchEffect));
        }
        CompoundNBT sizeNbt = new CompoundNBT();
        sizeNbt.func_74768_a("tagSIze", this.mainInventory.size());
        nbtTagList.add((Object)sizeNbt);
        this.freeSlots = this.mainInventory.size();
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).func_190926_b()) continue;
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.mainInventory.get(i)).func_77955_b(compoundNBT);
            nbtTagList.add((Object)compoundNBT);
            --this.freeSlots;
        }
        return nbtTagList;
    }

    public void read(ListNBT nbtTagList) {
        if (this.mainInventory.size() < nbtTagList.func_150305_b(0).func_74762_e("tagSIze")) {
            int size = nbtTagList.func_150305_b(0).func_74762_e("tagSIze");
            size -= size % 9;
            this.mainInventory = NonNullList.func_191197_a((int)size, (Object)ItemStackUtils.EMPTY);
        }
        this.freeSlots = this.mainInventory.size();
        for (int i = 1; i < nbtTagList.size(); ++i) {
            CompoundNBT compoundNBT = nbtTagList.func_150305_b(i);
            int j = compoundNBT.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compoundNBT);
            if (itemstack.func_190926_b() || j >= this.mainInventory.size()) continue;
            this.mainInventory.set(j, (Object)itemstack);
            --this.freeSlots;
        }
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            if (ItemStackUtils.isEmpty((ItemStack)this.mainInventory.get(slot)).booleanValue()) {
                --this.freeSlots;
            }
        } else if (!ItemStackUtils.isEmpty((ItemStack)this.mainInventory.get(slot)).booleanValue()) {
            ++this.freeSlots;
        }
        this.mainInventory.set(slot, (Object)stack);
    }
}

